#ifndef __CActionEvent__
#define __CActionEvent__

#include <Basics/CCountedObject.hpp>
#include "CMouseEvent.hpp"

//	===========================================================================

using Exponent::Basics::CCountedObject;
using Exponent::GUI::Events::CMouseEvent;

//	===========================================================================

#ifndef __ICONTROL_GUARD__
#define __ICONTROL_GUARD__
	namespace Exponent { namespace GUI { namespace Controls { interface IControl; } } }
	using Exponent::GUI::Controls::IControl;
#endif

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Events
		{
			/**
			 * @class CActionEvent CActionEvent.hpp
			 * @brief Allows for responding to control actions
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CActionEvent.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CActionEvent : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * @enum EActionEventType
				 * @brief Identifiers for the action events
				 */
				enum EActionEventType
				{
					e_controlChanged = 0,			/**< The control has changed */
					e_scroll,						/**< Scrolling of some sort @see CScrollEvent */
					e_menuChanged,					/**< Menu has changed @see CMenuEvent */
					e_otherEvent					/**< Some other (future) event */
				};

//	===========================================================================

				/**
				 * Construction
				 * @param control The control that generated the event
				 */
				CActionEvent(IControl *control);

				/**
				 * Construction with mouse
				 * @param control The control that generated the event
				 * @param mouseEvent The mouse event that triggered the control to change
				 */
				CActionEvent(IControl *control, const CMouseEvent &mouseEvent);

				/**
				 * Destruction
				 */
				virtual ~CActionEvent();

//	===========================================================================

				/**
				 * Get the control
				 * @retval IControl* The control that triggered the event
				 */
				virtual IControl *getControl() const;

				/**
				 * Get the event type
				 * @retval EActionEventType The type of event
				 */
				virtual EActionEventType getEventType() const;

//	===========================================================================

				/**
				 * Set the control
				 * @param control The control that generated the event
				 */
				virtual void setControl(IControl *control);

				/**
				 * Set the event type
				 * @param eventType The type of event
				 */
				virtual void setEventType(EActionEventType eventType);

//	===========================================================================

				/**
				 * Set the modifiers
				 * @param shift True if shift is down, false otherwise
				 * @param alt True if alt is down, false otherwise
				 * @param ctrl True if ctrl is down, false otherwise
				 */
				virtual void setModifiers(const bool shift, const bool alt, const bool ctrl);

				/**
				 * Is ctrl down
				 * @retval bool True if ctrl is down, false otherwise
				 */
				virtual bool isCtrlDown() const;

				/**
				 * Is shift down
				 * @retval bool True if shift is down, false otherwise
				 */
				virtual bool isShiftDown() const;

				/**
				 * Is the alt key down
				 * @retval bool True if alt is down, false otherwise
				 */
				virtual bool isAltDown() const;

//	===========================================================================

			protected:

//	===========================================================================

				IControl *m_control;					/**< Generating control */
				EActionEventType m_eventType;			/**< Type if event */

				bool m_shiftIsDown;						/**< Is shift key depressed */
				bool m_altIsDown;						/**< Is the alt key depressed */
				bool m_ctrlIsDown;						/**< Is the ctrl key depressed */

			};
		}
	}
}
#endif	// End of CActionEvent.hpp